{
  Search and replace demo.
  Shows how to lock window updates temporary while replacing
}

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, RVScroll, RichView, RVEdit, RVMisc, RVStyle, ImgList,
  RVTable, SclRView;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    bnnOpen: TButton;
    btnFind: TButton;
    btnReplace: TButton;
    fd: TFindDialog;
    rd: TReplaceDialog;
    OpenDialog1: TOpenDialog;
    il: TImageList;
    srve: TSRichViewEdit;
    procedure btnReplaceClick(Sender: TObject);
    procedure rdFind(Sender: TObject);
    procedure rdReplace(Sender: TObject);
    procedure rveRVFImageListNeeded(Sender: TCustomRichView;
      ImageListTag: Integer; var il: TCustomImageList);
    procedure btnFindClick(Sender: TObject);
    procedure fdFind(Sender: TObject);
    procedure bnnOpenClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure ShowInfo(const msg,cpt: String);
begin
  Application.MessageBox(PChar(msg),PChar(cpt),MB_OK or MB_ICONINFORMATION);
end;
{------------------------------------------------------------------------------}
function IsEqualText(s1, s2: String; CaseSensitive: Boolean): Boolean;
begin
  if CaseSensitive then
    Result := s1=s2
  else
    Result := AnsiLowerCase(s1)=AnsiLowerCase(s2);
end;
{=============================== REPLACE ======================================}
procedure TForm1.btnReplaceClick(Sender: TObject);
var s: String;
    p: Integer;
begin
  srve.SetFocus;
  fd.CloseDialog;
  if srve.RichViewEdit.SelectionExists then begin
    s := srve.RichViewEdit.GetSelText;
    p := Pos(#13,s);
    if p<>0 then s := Copy(s,1,p-1);
    rd.FindText := s;
  end;
  rd.Execute;
end;
{------------------------------------------------------------------------------}
procedure TForm1.rdFind(Sender: TObject);
begin
  if not srve.RichViewEdit.SearchText(rd.FindText,GetRVESearchOptions(rd.Options)) then
    ShowInfo('String not found','Search and Replace');
  srve.ScrollToCaret;
end;
{------------------------------------------------------------------------------}
procedure TForm1.rdReplace(Sender: TObject);
var c: Integer;
begin
  if frReplace in rd.Options then begin
    if IsEqualText(srve.RichViewEdit.GetSelText, rd.FindText,
      frMatchCase in rd.Options) then
      srve.RichViewEdit.InsertText(rd.ReplaceText,False);
    if not srve.RichViewEdit.SearchText(rd.FindText,GetRVESearchOptions(rd.Options)) then
      ShowInfo('String not found','Search and Replace');
    srve.ScrollToCaret;
    end
  else if frReplaceAll in rd.Options then begin
    srve.CanUpdate := FALSE;
    srve.SetBusy(True);
    srve.StopCursor;

    c := 0;
    if IsEqualText(srve.RichViewEdit.GetSelText, rd.FindText,
      frMatchCase in rd.Options) then begin
      srve.RichViewEdit.InsertText(rd.ReplaceText,False);
      inc(c);
    end;
    while srve.RichViewEdit.SearchText(rd.FindText,GetRVESearchOptions(rd.Options)) do begin
      srve.RichViewEdit.InsertText(rd.ReplaceText,False);
      inc(c);
    end;
    srve.StartCursor;
    srve.SetBusy(False);
    srve.CanUpdate := TRUE;
    srve.ScrollToCaret;
    ShowInfo(Format('There were %d replacements',[c]),'Replace');
  end;
end;
{================================= FIND =======================================}
procedure TForm1.btnFindClick(Sender: TObject);
var s: String;
    p: Integer;
begin
  srve.SetFocus;
  rd.CloseDialog;
  if srve.RichViewEdit.SelectionExists then begin
    s := srve.RichViewEdit.GetSelText;
    p := Pos(#13,s);
    if p<>0 then s := Copy(s,1,p-1);
    fd.FindText := s;
  end;
  fd.Execute;
end;
{------------------------------------------------------------------------------}
procedure TForm1.fdFind(Sender: TObject);
begin
  if not srve.RichViewEdit.SearchText(fd.FindText,GetRVESearchOptions(fd.Options)) then
    ShowInfo('String not found','Search');
  srve.ScrollToCaret;
end;
{==============================================================================}
procedure TForm1.rveRVFImageListNeeded(Sender: TCustomRichView;
  ImageListTag: Integer; var il: TCustomImageList);
begin
  il := Self.il;
end;
{------------------------------------------------------------------------------}
procedure TForm1.bnnOpenClick(Sender: TObject);
var
    r: Boolean;
begin
  if OpenDialog1.Execute then begin
    srve.RichViewEdit.Clear;
    case OpenDialog1.FilterIndex of
      1: // RVF
        r := srve.LoadRVF(OpenDialog1.FileName);
      2: // ANSI text
        r := srve.RichViewEdit.LoadText(OpenDialog1.FileName,0,0,False);
      else
        r := False;
    end;
    if not r then
      Application.MessageBox('Error during loading', 'Error', 0);
    srve.SetRVMargins;
    srve.RichViewEdit.Format;
    srve.SetFocus;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  srve.ViewProperty.ZoomMode := rvzmPageWidth;
end;

initialization

  RegisterClasses([TEdit,TButton]);

end.
